<?php
// lib/Auth.php
class Auth {
    private $db;

    public function __construct($mysqli) {
        $this->db = $mysqli;
    }

    public function getKey($apiKey) {
        $stmt = $this->db->prepare("SELECT id, status, daily_limit FROM api_keys WHERE api_key = ?");
        $stmt->bind_param('s', $apiKey);
        $stmt->execute();
        $stmt->bind_result($id, $status, $dailyLimit);
        if ($stmt->fetch()) {
            $stmt->close();
            return [
                'id'          => $id,
                'status'      => $status,
                'daily_limit' => $dailyLimit
            ];
        }
        $stmt->close();
        return null;
    }
}
?>
