<?php
// admin/keys.php - manage API keys
require_once __DIR__ . '/inc/auth.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/inc/header.php';

$message = '';
$error = '';

// Handle create new key
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'create') {
    $name  = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $daily_limit = (int)($_POST['daily_limit'] ?? 10000);

    if ($name === '') {
        $error = 'Name is required for API key.';
    } else {
        $api_key = bin2hex(random_bytes(16)); // 32-char key

        $stmt = $conn->prepare("
            INSERT INTO api_keys (api_key, name, email, daily_limit)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->bind_param('sssi', $api_key, $name, $email, $daily_limit);
        if ($stmt->execute()) {
            $message = 'API key created successfully.';
        } else {
            $error = 'Failed to create API key: ' . $conn->error;
        }
        $stmt->close();
    }
}

// Handle status toggle
if (isset($_GET['toggle']) && ctype_digit($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    $conn->query("UPDATE api_keys SET status = IF(status='active','disabled','active') WHERE id = {$id} LIMIT 1");
    $message = 'API key status updated.';
}

// Handle limit update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update_limit') {
    $id = (int)($_POST['id'] ?? 0);
    $daily_limit = (int)($_POST['daily_limit'] ?? 0);
    if ($id > 0 && $daily_limit > 0) {
        $stmt = $conn->prepare("UPDATE api_keys SET daily_limit = ? WHERE id = ?");
        $stmt->bind_param('ii', $daily_limit, $id);
        if ($stmt->execute()) {
            $message = 'Daily limit updated.';
        } else {
            $error = 'Failed to update limit.';
        }
        $stmt->close();
    }
}

// Fetch keys
$result = $conn->query("SELECT id, api_key, name, email, status, daily_limit, created_at FROM api_keys ORDER BY created_at DESC");
?>
<div class="row">
    <div class="col-md-4">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-dark text-white">
                <strong>Create New API Key</strong>
            </div>
            <div class="card-body">
                <?php if ($message): ?>
                    <div class="alert alert-success py-2"><?php echo htmlspecialchars($message); ?></div>
                <?php endif; ?>
                <?php if ($error): ?>
                    <div class="alert alert-danger py-2"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                <form method="post">
                    <input type="hidden" name="action" value="create">
                    <div class="mb-3">
                        <label class="form-label">Name (App / Client)</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email (optional)</label>
                        <input type="email" name="email" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Daily Limit</label>
                        <input type="number" name="daily_limit" class="form-control" value="10000" min="1">
                    </div>
                    <button type="submit" class="btn btn-dark w-100">Generate API Key</button>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-secondary text-white d-flex justify-content-between align-items-center">
                <strong>API Keys</strong>
                <span class="small">geoip.coffermedia.com</span>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-sm table-striped align-middle">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Key</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Daily Limit</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if ($result && $result->num_rows > 0): ?>
                        <?php while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo (int)$row['id']; ?></td>
                                <td>
                                    <code style="font-size: 0.8rem;"><?php echo htmlspecialchars($row['api_key']); ?></code>
                                </td>
                                <td><?php echo htmlspecialchars($row['name']); ?></td>
                                <td><?php echo htmlspecialchars($row['email']); ?></td>
                                <td>
                                    <?php if ($row['status'] === 'active'): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Disabled</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <form method="post" class="d-flex gap-1">
                                        <input type="hidden" name="action" value="update_limit">
                                        <input type="hidden" name="id" value="<?php echo (int)$row['id']; ?>">
                                        <input type="number" name="daily_limit"
                                               class="form-control form-control-sm"
                                               style="max-width: 90px;"
                                               value="<?php echo (int)$row['daily_limit']; ?>">
                                        <button class="btn btn-sm btn-outline-primary">Save</button>
                                    </form>
                                </td>
                                <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                                <td>
                                    <a href="?toggle=<?php echo (int)$row['id']; ?>"
                                       class="btn btn-sm btn-outline-warning"
                                       onclick="return confirm('Change status for this key?');">
                                        Toggle Status
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="8" class="text-center text-muted">No API keys found.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="card-footer small text-muted">
                Share only the <strong>API Key</strong> with your apps. Keep this panel private.
            </div>
        </div>
    </div>
</div>
<?php
require_once __DIR__ . '/inc/footer.php';
?>
