<?php
// cron/update_db.php
// This script downloads and updates the IP2Location LITE DB3 IPv6 BIN file.
// Configure your IP2Location LITE download URL below.

$downloadUrl = 'https://download.ip2location.com/lite/IP2LOCATION-LITE-DB3.IPV6.BIN.ZIP'; // replace with your licensed URL if needed
$localZip    = __DIR__ . '/IP2LOCATION-LITE-DB3.IPV6.BIN.ZIP';
$targetDir   = __DIR__ . '/../geo/';

if (!is_dir($targetDir)) {
    mkdir($targetDir, 0755, true);
}

// 1) Download ZIP
$zipStream = @fopen($downloadUrl, 'r');
if (!$zipStream) {
    file_put_contents(__DIR__ . '/update.log', date('Y-m-d H:i:s') . " - Failed to open download URL\n", FILE_APPEND);
    exit(1);
}

file_put_contents($localZip, $zipStream);

// 2) Extract ZIP
$zip = new ZipArchive;
if ($zip->open($localZip) === TRUE) {
    $zip->extractTo($targetDir);
    $zip->close();
    @unlink($localZip);

    // Optionally, rename extracted BIN to a known fixed name if needed
    // Many LITE archives already use IP2LOCATION-LITE-DB3.IPV6.BIN
    file_put_contents(__DIR__ . '/update.log', date('Y-m-d H:i:s') . " - DB updated successfully\n", FILE_APPEND);
} else {
    file_put_contents(__DIR__ . '/update.log', date('Y-m-d H:i:s') . " - Failed to unzip downloaded file\n", FILE_APPEND);
    exit(1);
}
?>
