<?php
// admin/logs.php - view API usage logs
require_once __DIR__ . '/inc/auth.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/inc/header.php';

// Fetch keys for filter
$keysResult = $conn->query("SELECT id, name FROM api_keys ORDER BY name ASC");

// Filters
$filterKeyId = isset($_GET['key_id']) && ctype_digit($_GET['key_id']) ? (int)$_GET['key_id'] : 0;
$filterDate  = trim($_GET['date'] ?? '');

$where = "1=1";
$params = [];
$types  = '';

if ($filterKeyId > 0) {
    $where .= " AND l.api_key_id = ?";
    $params[] = $filterKeyId;
    $types   .= 'i';
}

if ($filterDate !== '') {
    $where .= " AND DATE(l.created_at) = ?";
    $params[] = $filterDate;
    $types   .= 's';
}

$sql = "SELECT l.id, l.api_key_id, k.name AS key_name, l.client_ip, l.query_ip,
               l.country, l.region, l.city, l.user_agent, l.referer, l.created_at
        FROM api_logs l
        LEFT JOIN api_keys k ON l.api_key_id = k.id
        WHERE $where
        ORDER BY l.created_at DESC
        LIMIT 100";

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>
<div class="row">
    <div class="col-md-12">
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-secondary text-white d-flex justify-content-between align-items-center">
                <strong>API Usage Logs (Latest 100)</strong>
                <span class="small">geoip.coffermedia.com</span>
            </div>
            <div class="card-body">
                <form class="row g-3 mb-3" method="get" action="logs.php">
                    <div class="col-md-4">
                        <label class="form-label">API Key</label>
                        <select name="key_id" class="form-select">
                            <option value="0">All keys</option>
                            <?php if ($keysResult && $keysResult->num_rows > 0): ?>
                                <?php while ($k = $keysResult->fetch_assoc()): ?>
                                    <option value="<?php echo (int)$k['id']; ?>"
                                        <?php echo $filterKeyId === (int)$k['id'] ? 'selected' : ''; ?>>
                                        <?php echo (int)$k['id']; ?> - <?php echo htmlspecialchars($k['name']); ?>
                                    </option>
                                <?php endwhile; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Date (YYYY-MM-DD)</label>
                        <input type="date" name="date" value="<?php echo htmlspecialchars($filterDate); ?>" class="form-control">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-dark me-2">Filter</button>
                        <a href="logs.php" class="btn btn-outline-secondary">Reset</a>
                    </div>
                </form>

                <div class="table-responsive">
                    <table class="table table-sm table-striped align-middle">
                        <thead>
                        <tr>
                            <th>ID</th>
                            <th>Key</th>
                            <th>Client IP</th>
                            <th>Query IP</th>
                            <th>Location</th>
                            <th>User Agent</th>
                            <th>Referrer</th>
                            <th>Time</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if ($result && $result->num_rows > 0): ?>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo (int)$row['id']; ?></td>
                                    <td>
                                        <?php if ($row['api_key_id']): ?>
                                            <span class="badge bg-primary">
                                                #<?php echo (int)$row['api_key_id']; ?>
                                                <?php echo $row['key_name'] ? ' - ' . htmlspecialchars($row['key_name']) : ''; ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo htmlspecialchars($row['client_ip']); ?></td>
                                    <td><?php echo htmlspecialchars($row['query_ip']); ?></td>
                                    <td>
                                        <?php
                                        $loc = [];
                                        if (!empty($row['city'])) $loc[] = $row['city'];
                                        if (!empty($row['region'])) $loc[] = $row['region'];
                                        if (!empty($row['country'])) $loc[] = $row['country'];
                                        echo htmlspecialchars(implode(', ', $loc));
                                        ?>
                                    </td>
                                    <td>
                                        <span class="d-inline-block text-truncate" style="max-width: 200px;" title="<?php echo htmlspecialchars($row['user_agent']); ?>">
                                            <?php echo htmlspecialchars($row['user_agent']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="d-inline-block text-truncate" style="max-width: 180px;" title="<?php echo htmlspecialchars($row['referer']); ?>">
                                            <?php echo htmlspecialchars($row['referer']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="8" class="text-center text-muted">No logs found for this filter.</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <p class="small text-muted mt-2">
                    Showing latest 100 records. For deeper analysis later, you can export logs directly from the database.
                </p>
            </div>
        </div>
    </div>
</div>
<?php
$stmt->close();
require_once __DIR__ . '/inc/footer.php';
?>
